#!/usr/local/bin/perl
use DBI;
use strict;

if(@ARGV < 2)
{
	print "usage: perl this_program.pl num_topic word_assign_file wordmap_file output_file\n\n";
	exit(0);
}

my $K = shift @ARGV;
my $wassign_file = shift @ARGV;
my $wordmap_file = shift @ARGV;
my $out_file = shift @ARGV;


open os_html, ">".$out_file;
print os_html "<html>\n<head>\n<title>View file for topic model<\/title>\n<\/head>\n<body>\n<br>\n";


my $line;
my %word2id;
my %id2word;
my $color_span = 0xffffff / $K;

open is_wordmap, $wordmap_file;
$line = <is_wordmap>;#filtering the first line
while($line=<is_wordmap>){
  next if($line=~/^\s*\#/);
  chop($line);
  my @tmps = split(/\s+/, $line);
  $word2id{$tmps[0]} = $tmps[1];
  $id2word{$tmps[1]} = $tmps[0];
}
close(is_wordmap);

my $token;
my ($wordid, $topic, $authorid);
my $str;
my $docno=1;

open is_assign, $wassign_file;
while($line=<is_assign>){
  next if($line=~/^\s*\#/);
  $str = "$docno\. ";
  chop($line);
  my @tokens = split(/\s+/, $line);
  foreach $token (@tokens){
    ($wordid, $topic, $authorid) = split(/\:/, $token);
    $str .= "<font color=\"". ($color_span * $topic) . "\">". $id2word{$wordid} ."($topic)<\/font> \n";
  }
  print os_html $str."<br>\n";
  $docno++;
}
close(is_assign);

print os_html "<br>\n<\/body>\n<\/html>\n";
close(os_html);

