
use strict;


if(@ARGV < 2)
{
	print "usage: perl this_program.pl infile outfile\n\n";
	exit(0);
}

my $infile = shift @ARGV;
my $outfile = shift @ARGV;

my $line;
my @probs;
my @sim;
my $theta=0.0;
my $isprintsim=1;
my ($i, $j);


LoadFile($infile, \@probs);

open os, ">".$outfile if($outfile ne undef && length($outfile)>0);

for($i=0; $i<@probs; $i++){
  for($j=$i+1; $j<@probs; $j++){
    my $v = CalSimilarity(@probs[$i], @probs[$j]);
    $sim[$i][$j] = $v;
    $sim[$j][$i] = $v;
  }
}


#pirnt out
OutputFile($outfile, \@probs);

print "done!\n";
#end of main


sub CalSimilarity{
  my ($ps1, $ps2) = @_;
  my $i;
  my $ret = 0;
  my $denom1 = 0;
  my $denom2 = 0;
  
  for($i=0; $i<@$ps1; $i++){
    $ret += $$ps1[$i]*$$ps2[$i];
    $denom1 += $$ps1[$i]* $$ps1[$i];
    $denom2 += $$ps2[$i]* $$ps2[$i];
  }
  $denom1 = sqrt($denom1);
  $denom2 = sqrt($denom2);
  
  if($denom1==0 || $denom2==0){
    print "why denom is zero!\n";
    exit(0);
  }
  $ret /= $denom1 * $denom2;
  return $ret;
}


sub LoadFile{
  my ($infile, $probs) = @_;
  my $i;
  
  open(is, $infile);
  while(($line = <is>)){
    next if($line eq undef || length($line)<=0);
    my @ps = split(/\s+/, $line);
    $$probs[$i] = \@ps;
    $i++;
  }
  close(is);
}

sub OutputFile{
  my ($outfile, $probs) = @_;
  my $i;

  open(os, ">".$outfile);
  for($i=0; $i<@$probs; $i++){
    for($j=0; $j<@$probs; $j++){
      next if($i==$j);
      next if($sim[$i][$j]<$theta);
      print os $i." ".$j;
      if($isprintsim){
        print os " ".$sim[$i][$j];
      }
      print os "\n";
    }
  }
}


