

#include "model.h"
#include "utils.h"
#include <time.h>

using namespace std;

void show_help();

int main(int argc, char ** argv) {
//ATT model
	vector<string> vec;
	if(utils::isbatch(argc, argv, vec)){
		int ntopics[9] = {2, 5, 10, 20, 40, 60, 80, 100, 120};		
		//int ntopics[6] = {20, 40, 60, 80, 100, 120};

		for(int i=0; i<9; i++){
			char a[10];
			itoa(ntopics[i], a, 10);
			{
				int nparam = 9;
				char **params = new char*[nparam];
				params[0] = "-est";
				params[1] = "-ntopics";
				params[2] = a;
				params[3] = "-savestep";
				params[4] = "5000";
				params[5] = "-twords";
				params[6] = "10";
				params[7] = "-dfile";
				params[8] = (char*)vec[0].c_str();//"train2.txt";

				model lda;
				if (lda.init(nparam, params)) {
					show_help();
					return 1;
				}

				if (lda.model_status == MODEL_STATUS_EST || lda.model_status == MODEL_STATUS_ESTC) {
					// parameter estimation
					lda.estimate();
				}
				delete params;
			}
			{
				int nparam = 9;
				char **params = new char*[nparam];
				params[0] = "-inf";
				params[1] = "-dir";
				params[2] = "./";
				params[3] = "-model";
				string ss = "model-final";
				ss += a;
				params[4] = (char*)ss.c_str();
				params[5] = "-twords";
				params[6] = "10";
				params[7] = "-dfile";
				params[8] = (char*)vec[1].c_str();//"test2.txt";

				model lda;
				if (lda.init(nparam, params)) {
					show_help();
					return 1;
				}

				if (lda.model_status == MODEL_STATUS_INF) {
					// do inference
					lda.inference();
				}
				delete params;
			}
		}
	}else{	
		model lda;
		time_t e_start_time, e_end_time;
		
		e_start_time = time(NULL);

		if (lda.init(argc, argv)) {
			show_help();
			return 1;
		}
		e_end_time = time(NULL);
		e_end_time -= e_start_time;
		printf("elapsed for reading data: %d seconds\n", e_end_time);
	    
		e_start_time = time(NULL);
		if (lda.model_status == MODEL_STATUS_EST || lda.model_status == MODEL_STATUS_ESTC) {
			// parameter estimation
			//-est -ntopics 2 -savestep 2001 -twords 20 -dfile train.dat
			lda.estimate();
		}
		e_end_time = time(NULL);
		e_end_time -= e_start_time;
		printf( "elapsed for sampling: %d seconds\n", e_end_time);
	    
		if (lda.model_status == MODEL_STATUS_INF) {
			// do inference
			// -inf -dir ./ -model model-final -twords 10 -dfile yahoo2.txt
			//-inf -dir ./ -model model-final -twords 10 -dfile train.dat
			//-inf -dir ./ -model model-final -twords 10 -dfile arnet-test.dat
			
			lda.inference();
		}
	}
    
    return 0;
}

void show_help() {
    printf("Command line usage:\n");
    printf("\tlda -est -alpha <double> -beta <double> -ntopics <int> -niters <int> -savestep <int> -twords <int> -dfile <string>\n");
    printf("\tlda -estc -dir <string> -model <string> -niters <int> -savestep <int> -twords <int>\n");
    printf("\tlda -inf -dir <string> -model <string> -niters <int> -twords <int> -dfile <string>\n");
    // printf("\tlda -inf -dir <string> -model <string> -niters <int> -twords <int> -dfile <string> -withrawdata\n");
}

