

#ifndef _UTILS_H
#define _UTILS_H

#include <string>

using namespace std;

class model;

extern bool PairIDGreater ( pair<int, double> &elem1, pair<int, double> &elem2 );
extern bool PairIIGreater ( pair<int, int> &elem1, pair<int, int> &elem2 );

class utils {
public:
	static bool isbatch(int argc, char ** argv, vector<string> & vec);

    // parse command line arguments
    static int parse_args(int argc, char ** argv, model * pmodel);
    
    // read and parse model parameters from <model_name>.others
    static int read_and_parse(string filename, model * model); 
    
    // generate the model name for the current iteration
    // iter = -1 => final model
    static string generate_model_name(int iter);  
    
    // sort    
    static void sort(vector<double> & probs, vector<int> & words);
    static void quicksort(vector<pair<int, double> > & vect, int left, int right);
	static void quicksort(vector<pair<int, int> > & vect, int left, int right);
	static void quicksort(pair<int, double> *data, int left, int right);
	static string trimstring(string & in);
	static string int2str(int num);

};

#endif

