#include "graph.h"
#include <vector>
#include <cstdio>
#include <iostream>
#include <cfloat>
using namespace std;

int Graph::n;
int Graph::m;
int *Graph::nrmi;
int *Graph::degree, *Graph::idegree;
bool *Graph::status;
//static vector<int> index;
vector<vector<Edge>> Graph::edge;
vector<vector<Edge>> Graph::iedge;
message **Graph::rmo;
message *Graph::sm;
map<int,int> Graph::mapid;
vector<int> Graph::imap;

void	Graph::Build(char *mapname)
{
	scanf_s("%d %d",&n,&m);
	degree=new int[n+1];
	idegree=new int[n+1];
	status=new bool[n+1];
	nrmi=new int[n+1];
	edge.resize(n+1);
	//cout<<edge[0][0].ed<<endl;
	iedge.resize(n+1);
	rmo=new message*[n+1];
	sm=new message[n+1];

	int i,j,u,v,st,ed;
	double prob;
	iedge[0].resize(n);
	idegree[0]=n;
	degree[0]=1;
	edge[0].push_back(Edge(0,1,MAXTIME,0));
	for (j=1;j<n+1;j++)
	{
		degree[j]=1;
		Edge e(0,0,MAXTIME,0);
		edge[j].push_back(e);
		//edge[j][0]=e;
		//edge[j][0].v=0;
		//edge[j][0].st=0;
		//edge[j][0].ed=0;
		idegree[j]=0;
		//iedge[0][j-1]=e;
		//iedge[0].push_back(e);
		iedge[0][j-1].v=j;
		status[j]=false;
	}
	//printf("%d\n",idegree[0]);
	for (i=0;i<m;i++)
	{
		scanf_s("%d %d %lg %d %d",&u,&v,&prob,&st,&ed);
		j=degree[u]++;
		Edge e(v,prob,st,ed);
		edge[u].push_back(e);
		int k,l;
		for (k=1;k<j && edge[u][k].prob>=prob;k++);
		for (l=j;l>k;l--) edge[u][l]=edge[u][l-1];
		edge[u][k]=e;
		//edge[u][j].v=v;
		//edge[u][j].prob=prob;
		//edge[u][j].st=st;
		//edge[u][j].ed=ed;
		//assert(v);
		j=idegree[v]++;
		iedge[v].push_back(e);
		iedge[v][j].v=u;
		if (u==19991) {
			u=17302;
			j=degree[u]++;
			Edge e(v,prob,st,ed);
			edge[u].push_back(e);
			int k,l;
			for (k=1;k<j && edge[u][k].prob>=prob;k++);
			for (l=j;l>k;l--) edge[u][l]=edge[u][l-1];
			edge[u][k]=e;
			//edge[u][j].v=v;
			//edge[u][j].prob=prob;
			//edge[u][j].st=st;
			//edge[u][j].ed=ed;
			//assert(v);
			j=idegree[v]++;
			iedge[v].push_back(e);
			iedge[v][j].v=u;
		}
	}
	for (j=1;j<n+1;j++)
	{
		//prob of node j to 0
		//double max=0;
		//for (i=1;i<degree[j];i++)
		//	if (max<edge[j][i].prob) max=edge[j][i].prob;
		//if (degree[j]==1) edge[j][0].prob=1; else edge[j][0].prob=(1-max);
		double prod=1;
		for (i=1;i<degree[j];i++)
		{
			prod*=(1-edge[j][i].prob);
			if (edge[j][i].ed-edge[j][i].st<3) edge[j][i].prob-=edge[j][i].prob*factor*(3-edge[j][i].ed+edge[j][i].st)/4;
			if (edge[j][i].ed-edge[j][i].st>3) edge[j][i].prob-=edge[j][i].prob*factor*(edge[j][i].ed-edge[j][i].st-3)/4;
		}
		if (degree[j]==2) 
			//if (edge[j][1].prob>0.5) prod=0.01;	else 
				prod*=prod*prod; 
		else if (degree[j]<4 || edge[j][1].prob<0.5) prod*=prod;
		edge[j][0].prob=prod;
	}
		//printf("OK\n");
	if (mapname)
	{
		FILE *file;
		freopen_s(&file,mapname,"r",stdin);
		int sn=-1;
		while (!feof(stdin))
		{
			if (!scanf_s("%d %d\n",&u,&v)) break;
			mapid[u]=v;
			sn++;
			imap.push_back(u);
		}
		//printf("%d\n",sn);
		fclose(file);
		vector<vector<Edge>> newedge;
		newedge.resize(sn+1);
		vector<vector<Edge>> newiedge;
		newiedge.resize(sn+1);
		int *newdegree=new int[sn+1];
		int *newidegree=new int[sn+1];
		for (i=0;i<=sn;i++)
		{
			newdegree[i]=newidegree[i]=0;
			for (j=0;j<degree[imap[i]];j++)
			{
				int v=edge[imap[i]][j].v;
				map<int,int>::iterator p=mapid.find(v);
				if (p!=mapid.end()) {
					edge[imap[i]][j].v=p->second;
					newedge[i].push_back(edge[imap[i]][j]);
					newdegree[i]++;
				}
			}
			for (j=0;j<idegree[imap[i]];j++)
			{
				int v=iedge[imap[i]][j].v;
				map<int,int>::iterator p=mapid.find(v);
				if (p!=mapid.end()) {
					iedge[imap[i]][j].v=p->second;
					newiedge[i].push_back(iedge[imap[i]][j]);
					newidegree[i]++;
				}
			}
		}
		delete[] degree;
		delete[] idegree;
		edge.resize(sn+1);
		iedge.resize(sn+1);
		//edge=newedge;
		//iedge=newiedge;
		degree=newdegree;
		idegree=newidegree;
		m=0;
		for (i=0;i<=sn;i++)
		{
			edge[i]=newedge[i];
			iedge[i]=newiedge[i];
			m+=degree[i]-1;
		}
		n=sn;
	}
	else for (i=0;i<=n;i++) imap.push_back(i);
	for (j=0;j<n+1;j++)
	{
		nrmi[j]=0;
		rmo[j]=new message[degree[j]];		
	}
	//printf("OK\n");
}

void	Graph::Build(bool ins)
{
	scanf_s("%d %d",&n,&m);
	degree=new int[n+1];
	idegree=new int[n+1];
	status=new bool[n+1];
	nrmi=new int[n+1];
	edge.resize(n+1);
	//cout<<edge[0][0].ed<<endl;
	iedge.resize(n+1);
	rmo=new message*[n+1];
	sm=new message[n+1];

	int i,j,u,v,st,ed;
	double prob;
	iedge[0].resize(n);
	idegree[0]=n;
	degree[0]=1;
	edge[0].push_back(Edge(0,1,MAXTIME,0));
	for (j=1;j<n+1;j++)
	{
		degree[j]=1;
		Edge e(0,0,MAXTIME,0);
		edge[j].push_back(e);
		//edge[j][0]=e;
		//edge[j][0].v=0;
		//edge[j][0].st=0;
		//edge[j][0].ed=0;
		idegree[j]=0;
		//iedge[0][j-1]=e;
		//iedge[0].push_back(e);
		iedge[0][j-1].v=j;
		status[j]=false;
	}
	//printf("%d\n",idegree[0]);
	for (i=0;i<m;i++)
	{
		scanf_s("%d %d %lg %d %d",&u,&v,&prob,&st,&ed);
		j=degree[u]++;
		Edge e(v,prob,st,ed);
		edge[u].push_back(e);
		int k,l;
		for (k=1;k<j && edge[u][k].prob>=prob;k++);
		for (l=j;l>k;l--) edge[u][l]=edge[u][l-1];
		edge[u][k]=e;
		//edge[u][j].v=v;
		//edge[u][j].prob=prob;
		//edge[u][j].st=st;
		//edge[u][j].ed=ed;
		//assert(v);
		j=idegree[v]++;
		iedge[v].push_back(e);
		iedge[v][j].v=u;
		
	}
	for (j=1;j<n+1;j++)
	{
		//prob of node j to 0
		//double max=0;
		//for (i=1;i<degree[j];i++)
		//	if (max<edge[j][i].prob) max=edge[j][i].prob;
		//if (degree[j]==1) edge[j][0].prob=1; else edge[j][0].prob=(1-max);
		double prod=1;
		for (i=1;i<degree[j];i++)
			prod*=(1-edge[j][i].prob);
		if (degree[j]<2) prod*=prod*prod; else if (degree[j]<3 || edge[j][1].prob<0.5) prod*=prod;
		edge[j][0].prob=prod;
		if (ins)
		{
			Edge e=edge[j][0];
			edge[j].push_back(e);
			degree[j]++;
			int k,l;
			for (k=1;k<degree[j] && edge[u][k].prob>=prod;k++);
			for (l=degree[j];l>k;l--) edge[u][l]=edge[u][l-1];
			edge[u][k]=e;
		}
	}
	for (j=0;j<n+1;j++)
	{
		nrmi[j]=0;
		rmo[j]=new message[degree[j]];		
	}
}

int	Graph::GetN()
{
	return n;
}

int	Graph::GetM()
{
	return m;
}

int	Graph::GetDegree(int node)
{
	return degree[node];
}

int	Graph::GetIDegree(int node)
{
	return idegree[node];
}

int	Graph::GetNeighbor(int node)
{
	return degree[node]+idegree[node];
}

Edge	Graph::GetEdge(int node, int idx)
{
	return edge[node][idx];
}

Edge	Graph::GetIEdge(int node, int idx)
{
	return iedge[node][idx];
}

Edge Graph::GetUEdge(int node, int idx)
{
	if (idx<degree[node]) return edge[node][idx];
	else return iedge[node][idx-degree[node]];
}

message Graph::GetSM(int node)
{
	return sm[node];
}

void Graph::pushSM(int node, message m)
{
	sm[node]=m;
}

message *Graph::GetRMO(int node)
{
	return rmo[node];
}
bool Graph::receiveMessage(int node)
{
	return (++nrmi[node]==idegree[node]);
}
void Graph::Stats()
{
}

void Graph::updateProb(int node, int idx, double prob)
{
	if (!_isnan(prob)) edge[node][idx].prob=prob;
	Edge e=edge[node][idx];
	int i,j;
	for (i=0;i<idx && edge[node][i].prob>=edge[node][idx].prob;i++);
	for (j=idx;j>i;j--) edge[node][j]=edge[node][j-1];
	edge[node][i]=e;
}

int Graph::originalid(int x)
{
	return imap[x];
}