#ifndef GRAPH_H
#define GRAPH_H

#include "limit.h"
#include <vector>
#include <list>
#include <map>
using namespace std;

struct Edge 
{
	int v,st,ed;	
	double prob;

	Edge(int v, double prob, int st, int ed):v(v),prob(prob),st(st),ed(ed)
	{
	}

	Edge()
	{
	}

};

struct message
{
	list<Edge> value;
};

class Graph
{
private:
	static bool built;
	static int n;
	static int m;
	static int *nrmi; // number of received message from incoming edge
	static int *degree, *idegree;
	static bool *status;
	//static vector<int> index;
	static vector<vector<Edge>> edge;
	static vector<vector<Edge>> iedge;
	static message **rmo,**rmi; //message recevied from outcoming edge, incoming edge
	static message *sm; //single message sent
	//static void qsort_edges(int h, int t);
	static map<int,int> mapid;
	static vector<int> imap;

public:
	static void	Build(char *name=NULL);
	static int	GetN();
	static int	GetM();
	static int	GetDegree(int node);
	static int	GetIDegree(int node);
	static int	GetNeighbor(int node);
	static Edge	GetEdge(int node, int idx);
	static Edge GetIEdge(int node, int idx);
	static Edge	GetUEdge(int node, int idx);
	static message GetSM(int node);
	//static vector<message> GetRMO(int node);
	static message* GetRMO(int node);
	static void pushSM(int node, message sm);
	static void pushRMO(int node, message rmo);
	static bool receiveMessage(int node);
	static void Stats();
	static void updateProb(int node, int idx, double prob);
	static void	Build(bool ins);
	static int originalid(int x);
};

#endif

