#pragma once

#include "Config.h"
#include "DataSet.h"
#include "FactorGraph.h"

class EdgeFactorFunction: public FactorFunction
{
public:
    int*    label_id;
    int*    num_label;
    double* lambda;                 //???
    map<int, int>* feature_offset;  //???

    EdgeFactorFunction(int* label_id, int* num_label, double* p_lambda, map<int,int>* feature_offset)
    {
        this->num_label = new int[2];
        this->num_label[0] = num_label[0];
        this->num_label[1] = num_label[1];
        this->label_id = new int[2];
        this->label_id[0] = label_id[0];
        this->label_id[1] = label_id[1];
        //this->num_label = num_label;
        this->lambda = p_lambda;
        this->feature_offset = feature_offset;
    }

    virtual ~EdgeFactorFunction()
    {
        if (lambda)
            delete[] lambda;
        if (label_id)
            delete[] label_id;
        if (num_label)
            delete[] num_label;
    }
    
    virtual double GetValue(int y1, int y2)
    {
        int i = (*feature_offset)[ y1 * num_label[1] + y2 ];
        return exp ( lambda[i] );
    }

	virtual double GetValue(int a, int b, int c)
	{
		int i = (*feature_offset)[ a * num_label[1] * num_label[2] + b * num_label[1] + c];
		return exp ( lambda[i] );
	}
};

class CRFModel
{
public:
    Config*     conf;
    DataSet*    train_data;
    DataSet*    test_data;

    int         num_sample;
    int         num_label_id;
    int         num_attrib_type;
    int         num_edge_type;
	int         num_triangle_type;
    int*        num_label;
            
    int         num_feature;

    double      *lambda;
    FactorGraph *sample_factor_graph;

    int             num_attrib_parameter;
    int             num_edge_feature_each_type[10];
	int				num_triangle_feature_each_type[10];
    map<int, int>   edge_feature_offset[10];
	map<int, int>   triangle_feature_offset[10];
    EdgeFactorFunction**   edge_func_list;
	EdgeFactorFunction**   triangle_func_list;
	

    CRFModel(){}

    void InitTrain(Config* conf, DataSet* train_data);
    void GenFeature();
    void SetupFactorGraphs();

    void Train();
    double CalcGradient(double* gradient);
    double CalcGradientForSample(DataSample* sample, FactorGraph* factor_graph, double* gradient);
    double CalcPartialLabeledGradientForSample(DataSample* sample, FactorGraph* factor_graph, double* gradient);

    void SelfEvaluate();
    
    void InitEvaluate(Config* conf, DataSet* test_data);
    void Evalute();

    int GetAttribParameterId(int y, int x){ return y * num_attrib_type + x; }

    int GetEdgeParameterId(int i, int j, int y1, int y2)
    { 
        int offset = edge_feature_offset[i * num_label_id + j][ y1 * num_label[j] + y2 ];
        int id = num_edge_feature_each_type[i * num_label_id + j] + offset;
        //printf("Edge_ID: %d\n", id);
        return id;
    }

	int GetTriangleParameterId(int i, int j, int k, int a, int b, int c)
	{
        //printf("%d %d %d %d %d %d\n", i, j, k, a, b, c);
        int triangle_type = i * num_label_id * num_label_id + j * num_label_id + k;
        //printf("%d %d\n", triangle_type, a * num_label[j] * num_label[k] + b * num_label[k] + c);
        //printf("%d\n", triangle_feature_offset[triangle_type].size());
		int offset = triangle_feature_offset[triangle_type][a * num_label[j] * num_label[k] + b * num_label[k] + c];
		int id = num_triangle_feature_each_type[triangle_type] + offset;
        //printf("Triangle_ID: %d\n", id);
		return id;
	}

    ~CRFModel() { Clean(); }
    void Clean();

    void SaveModel(const char* file_name);
    void LoadModel(const char* file_name);
};
